/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import android.util.Log;
import com.ftdi.j2xx.InBuffer;
import com.ftdi.j2xx.ProcessInCtrl;

class ProcessRequestWorker
implements Runnable {
    private ProcessInCtrl mInCtrl;
    int mNrBuf;

    ProcessRequestWorker(ProcessInCtrl inCtrl) {
        this.mInCtrl = inCtrl;
        this.mNrBuf = this.mInCtrl.getParams().getBufferNumber();
    }

    public void run() {
        InBuffer inBuf = null;
        int bufferIndex = 0;
        try {
            do {
                if ((inBuf = this.mInCtrl.acquireReadableBuffer(bufferIndex)).getLength() > 0) {
                    this.mInCtrl.processBulkInData(inBuf);
                    inBuf.purge();
                }
                this.mInCtrl.releaseWritableBuffer(bufferIndex);
                ++bufferIndex;
                bufferIndex %= this.mNrBuf;
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            Log.d((String)"ProcessRequestThread::", (String)"Device has been closed.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.e((String)"ProcessRequestThread::", (String)"Fatal error!");
        }
    }
}

